
/* these are the byte counts used when reading/writing a AGCR	*/
/* sector for the SVD file format.				*/

#define AGCR_LEADING_HEADER_BYTES	14
#define AGCR_SECTOR_HEADER_BYTES	15

/* Raw nibble format is weird.  The concept (for this file anyway) is	*/
/* that the data routine in the firmware keys off of the FIRST sector	*/
/* marking in the header, then takes over generating the COMPLETE track,*/
/* unlike all of the other formats that generate each sector separately.*/
/* So the data in the header is mostly unused.  The first sector mark is*/
/* important, as well as the trailer mark.				*/
/*									*/
/* SOOOoooo, even though the header data isn't really used, it is filled*/
/* in.  This is done so that the tools will read in the same data from	*/
/* an svd-format file that they would from the raw data file.  Note,	*/
/* too, that the header is aligned so that the last byte is the trailer	*/
/* mark.								*/
/* sector 1 = 1 sector mark + 4 data bytes                 =  5		*/
/* sector 2 - 26 = 1 sector mark + 4 data bytes + 5 spaces = 10		*/
/*          1 * 5 + 25 * 10 = 255   plus one trailer mark		*/
/*									*/
/* Note that in this format the "sectors" really aren't sectors, instead*/
/* they are simply data blocks for a 6656-byte track (26 sectors).  They*/
/* are replayed back to back.						*/
/*									*/
/* As far as data alignment, all "sectors" are aligned in EXACTLY the	*/
/* same fashion...to save precious time when generating a sector.  That	*/
/* is, the first byte is at byte 1 (as opposed to zero) right after the	*/
/* first sector mark.  All subsequent "sectors" start at byte 1, too.	*/
/* After generating all sectors, 254 increments are done to position	*/
/* memory to point to the trailer mark.					*/
/*									*/
/* The constants below are used to align the data.			*/

#define RNIB_LEADING_HEADER_BYTES	1
#define RNIB_SECTOR_HEADER_BYTES	0


